//19/11/2018



//////////////////////////////////////////////////////////////////////
//
//  Auxiliary functions for Maximal Curves
//
//////////////////////////////////////////////////////////////////////


//Given a list of groups of the GL(Z/nZ) returns the maximal elements ordered by containment.
function MaximalReps(S)
	G := GL(2,BaseRing(S[1]));
	I:=Sort([<Index(G,S[i]),i>:i in [1..#S]]);
	indexes:={i[1]:i in I};
	U:=[<S[I[1][2]],I[1][1],AssociativeArray(indexes)>];
	for n in indexes do 
		if IsDivisibleBy(n,U[1][2]) then 
			U[1][3][n] := [K`subgroup: K in Subgroups(U[1][1]:IndexEqual:=n div U[1][2])]; 
		end if; 
	end for;
	for i:=2 to #I do
        H:=S[I[i][2]];
        Hn :=I[i][1];
        keep := true;
        for j:=1 to #U do
            if IsDivisibleBy(Hn,U[j][2]) then
                for K in U[j][3][Hn] do 
                	assert #H eq #K; 
                	if IsConjugate(G,H,K) then 
                		keep:= false; 
                		break; 
                	end if;
                end for;
                if not keep then break; end if;
            end if;
        end for;
        if keep then
            r:=<H,Hn,AssociativeArray(indexes)>;
            for n in indexes do 
            	if IsDivisibleBy(n,Hn) then 
            		r[3][n] := [K`subgroup:K in Subgroups(H:IndexEqual:=n div Hn)]; 
            	end if; 
            end for;
            U:=Append(U,r);
        end if;
    end for;
    S:=[r[1]:r in U];
	return S;
end function;


//////////////////////////////////////////////////////////////////////
//
//  Maximal Curves with finitely many points
//
//////////////////////////////////////////////////////////////////////

load "FiberProductsDataadiconlymaximal.m";

load "output_genus1.txt";

curves_with_infinitely_many_points:=Seqset(CurvesByGenus[0]) join Seqset(Genus1PosRank);

curves_with_finitely_many_points:={k : k in Keys(FiberProducts) | not k in curves_with_infinitely_many_points};

S:=curves_with_finitely_many_points;



levels := {FiberProducts[k]`level : k in S};
MaxLabels := AssociativeArray();
MaxGrps := AssociativeArray();

for lev in levels do
	MaxGrps[lev] := MaximalReps([FiberProducts[key]`group : key in S| FiberProducts[key]`level eq lev]);
	MaxLabels[lev] :=[];
end for;


for k in S do
	G := FiberProducts[k]`group;
	lev := FiberProducts[k]`level;
	if G in MaxGrps[lev] then
		Append(~MaxLabels[lev],k);
	end if;
end for;


print "Level - Curves";
for lev in Sort([l : l in levels]) do
	lev, MaxLabels[lev];
end for;


MaximalCurvesByGenus := AssociativeArray();
for lev in Keys(MaxLabels) do
	for k in MaxLabels[lev] do
		for g in Keys(CurvesByGenus) do 
			if k in CurvesByGenus[g] then
				if g in Keys(MaximalCurvesByGenus) then
					Append(~MaximalCurvesByGenus[g],k);
				  else 
				    MaximalCurvesByGenus[g] := [k];
				end if;
			end if;
		end for;
	end for;
end for;

for g in Sort(Setseq(Keys(MaximalCurvesByGenus))) do 
	MaximalCurvesByGenus[g]:=Sort(MaximalCurvesByGenus[g]);
end for;

/////////////////////////////////////////////////////////////


print "--- Genus g - #MaximalCurvesByGenus[g] ---";
for g in Sort(Setseq(Keys(MaximalCurvesByGenus))) do 
	g, #MaximalCurvesByGenus[g];
end for;

/////////////////////////////////////////////////////////////

//Print the MaximalCurvesByGenus data

fprintf "MaximalCurvesFinitelyManyPoints.m", "%o", "MaximalCurvesByGenus := AssociativeArray();\n";
for g in Sort(Setseq(Keys(MaximalCurvesByGenus))) do
	list := MaximalCurvesByGenus[g];
	fprintf "MaximalCurvesFinitelyManyPoints.m", "MaximalCurvesByGenus[%o] := [\n",g;
	for i in [1..#list] do
		k := list[i];
		if i ne #list then
			fprintf "MaximalCurvesFinitelyManyPoints.m", "[\"%o\",\"%o\"],\n", k[1],k[2];
		end if;
		if i eq #list then
			fprintf "MaximalCurvesFinitelyManyPoints.m", "[\"%o\",\"%o\"]\n", k[1],k[2];
		end if;		
	end for;
	fprintf "MaximalCurvesFinitelyManyPoints.m", "];\n";
end for;
